/*
 * 쐬: 2008/08/05
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.entity.rule;

import java.sql.Types;

import zigen.plugin.db.core.TableColumn;

public class H2EntityMappingFactory extends DefaultEntityMappingFactory {
	
	public String getJavaType(TableColumn column) {
		return getJavaType(column.getDataType());
	}
	
	// java.lang.* ͋LڂȂ
	public String getJavaType(int type) {
		switch (type) {
			case Types.CHAR:
			case Types.VARCHAR:
			case Types.LONGVARCHAR:
				return "String"; //$NON-NLS-1$
				
			case Types.NUMERIC:
			case Types.DECIMAL:
				// return "java.math.BigDecimal";
				return "Long"; // H2ł́ABigDecimalł͂ȂLong^ //$NON-NLS-1$
				
			case Types.BIT:
				return "Boolean"; //$NON-NLS-1$
				
			case Types.TINYINT:
				return "Byte"; //$NON-NLS-1$
				
			case Types.SMALLINT:
				return "Short"; //$NON-NLS-1$
				
			case Types.INTEGER:
				return "Integer"; //$NON-NLS-1$
				
			case Types.BIGINT:
				return "Long"; //$NON-NLS-1$
				
			case Types.REAL:
				return "Float"; //$NON-NLS-1$
				
			case Types.FLOAT:
			case Types.DOUBLE:
				return "Double"; //$NON-NLS-1$
				
			case Types.BINARY:
			case Types.VARBINARY:
			case Types.LONGVARBINARY:
				return "byte[]"; //$NON-NLS-1$
				
			case Types.TIME:
				return "java.sql.Time"; //$NON-NLS-1$
				
			case Types.DATE:
				return "java.sql.Date"; //$NON-NLS-1$
				
			case Types.TIMESTAMP:
				return "java.sql.Timestamp"; //$NON-NLS-1$
				
			case Types.CLOB:
			case Types.BLOB:
			case Types.OTHER:
				return "Object"; //$NON-NLS-1$
				
			default:
				return "<<???>>"; //$NON-NLS-1$
		}
	}
	
}